<?php

include_once 'initialize.php';
include_once 'SecurityCheck.php';
include_once 'conn_db_wp.php';
include_once 'jdf.php';

include_once 'Utils_Funcs.php';

include_once 'conn_db.php'; //Now Just For mysql => real_escape_string And ChangeStatisticsView.php
$querysearch = $conn->real_escape_string($_GET['querysearch']);

$limitval    = ($_GET['limitval']);
$offsetval   = ($_GET['offsetval']);

if(isset($limitval) && !empty($limitval)){
    
    $searchQuery = get_compiled_searchQuery($querysearch, array('posts.`post_title`'
    , 'posts.`post_content`'));
    
    $query = "SELECT posts.ID,post_title,post_content,post_date FROM `wp_posts` as posts
	LEFT JOIN `wp_users` as wuser ON posts.`post_author` = wuser.`ID`
	LEFT JOIN `wp_term_relationships` as wtr ON wtr.`object_id` = posts.`ID`
    LEFT JOIN `wp_term_taxonomy` as wtt ON wtt.`term_taxonomy_id` = wtr.`term_taxonomy_id`
	LEFT JOIN `wp_terms` as wt ON wt.`term_id` = wtt.`term_id`
	LEFT JOIN `wp_postmeta` as postmeta ON posts.`id` = postmeta.`post_id`
	WHERE posts.`post_type` = 'post' AND (posts.post_status = 'publish' OR posts.post_status = 'private') AND wtt.`taxonomy` = 'category' AND wt.term_id = '753' ".$searchQuery." GROUP BY posts.`ID` ORDER BY posts.post_date DESC LIMIT :limit OFFSET :offset";
    
  $result = $db->prepare($query);
  $result->execute([ 'limit' => $limitval, 'offset' => $offsetval ]);
  
 if (is_array($result) || is_object($result)) {
 
    $data = array(); 
	foreach ($result as $print) {
	    
	    $date_miladi = $print['post_date'];
        $date_shamsi = jdate("Y/m/d H:i", strtotime($date_miladi));
        if (jdate("Y/m/d", strtotime($date_miladi)) === jdate("Y/m/d", time())) {
            $is_post_todaypublished = true;
        } else {
            $is_post_todaypublished = false;
        }
        
        $post_content = getFinalContent($print['post_content']);

		$data[] = array(
            "id" => $print['ID'],
            "post_title" => $print['post_title'],
            "post_content" => $post_content,
            "post_date" => $date_shamsi,
            "itp" => $is_post_todaypublished
        );
	}
	
	Print json_encode($data);
	
    include_once 'ChangeStatisticsView.php';
    ChangeStatisticsView($conn, "news");
 
 } else {
    echo 'Error_Connection';
 }
 
}

function getFinalContent($html) {

    return remove_empty_tags(preg_replace('#<div id="whitelisted"(.*?)</div>#', '', $html));
    
}

function remove_empty_tags ($string, $rep = NULL)
{
   if (!is_string ($string)
      || trim ($string) == '')
          return $string;

   return preg_replace ('/<([^<\/>]*)>([\s]*?|(?R))<\/\1>/imsU',!is_string ($rep) ? '' : $rep,$string);
}

?>