<?php

include_once 'initialize.php';
include_once 'SecurityCheck.php';
include_once 'conn_db.php';
include_once 'jdf.php';

mysqli_set_charset($conn, "utf8");

$action    = $_GET['action']; //با کوئری دیتابیس ارتباطی نداره

$limitval    = $conn->real_escape_string($_GET['limitval']);
$offsetval   = $conn->real_escape_string($_GET['offsetval']);

if ($action == "getcompanies_name") {
    $querysearch = $conn->real_escape_string($_GET['querysearch']); //unsafe to safe
    
    include_once 'Utils_Funcs.php';
    $searchQuery = get_compiled_searchQuery($querysearch, array('t_ss.sname'));
    
    $sql    = "SELECT
t_mc.id, t_ss.sname as name, t_mc.final_pricepershare, t_mc.count_participants, Date(t_mc.datesubmit) as datesubmit, t_mc.date_update 
FROM prices_predicted as t_pp
INNER JOIN matchs as t_mc ON t_pp.company_id = t_mc.id 
INNER JOIN stock_shares as t_ss ON t_mc.symbol_id = t_ss.id
WHERE (t_mc.final_pricepershare <> '' AND t_mc.final_pricepershare > 0)" . $searchQuery . " GROUP BY t_pp.company_id 
ORDER BY t_mc.id DESC" . " LIMIT " . $limitval . " OFFSET " . $offsetval;
    $result = $conn->query($sql);
    
    $data = array();
    if ($result->num_rows > 0) {
        
        // output data of each row
        while ($row = $result->fetch_assoc()) {
            
            $date_submit = jdate("Y/m/d", strtotime($row['datesubmit']));
            $date_update = jdate("Y/m/d ، H:i", strtotime($row['date_update']));
            
            $data[] = array(
                "id" => $row['id'],
                "name" => $row['name'],
                "date_submit" => $date_submit,
                "final_pricepershare" => $row['final_pricepershare'],
                "count_participants" => $row['count_participants'],
                "date_update" => $date_update
            );
        }
    }
    
    Print json_encode($data);
    
} else {
    // getresults_match
    include_once 'Utils_Match.php';
    include_once 'Utils_Funcs.php';
    
    $match_id = $conn->real_escape_string($_GET['id']);
    
    $sql2 = getQueryRanking_Match($match_id, true, $limitval, $offsetval);
    $result2 = $conn->query($sql2);
    
    $data = array();
    if ($result2->num_rows > 0) {
        
         
        $max_count_top = 3;
        $isFirstRequest = ($offsetval == 0); //<= $max_count_top
        $isNeedToCalculate_Ranking = $isFirstRequest;
        $index = 0;
        
        // output data of each row
        while ($row2 = $result2->fetch_assoc()) {
            
            $phone_number = $row2['phone_number'];
            if (strlen($phone_number) >= 11) {
                $len                   = strlen($phone_number);
                $phone_number_filtered = substr($phone_number, 0, 4) . "***" . substr($phone_number, 7, $len - 1);
            }
            
            $price = $row2['price'];
            
            $date_miladi = $row2['date_submit'];
            $date_shamsi = jdate("Y/m/d ، H:i:s", strtotime($date_miladi));
            $date_submit = $date_shamsi;
            
            if ($isNeedToCalculate_Ranking) {
                if (($index+1) > $max_count_top) {
                    $isTop = 0;
                } else {
                    $isTop = 1;
                }
            
                $index ++;
                
            }else {
                $isTop = -1;
            }


            //---------------------------------------------
            $final_pricepershare = $row2['final_pricepershare'];
            $diff_per = "";
            
            if (is_numeric($final_pricepershare) && $final_pricepershare > 0) {
                $diff_per = getDiff_TwoNumbers_toPercentage_withSign($final_pricepershare, $price);
            }  
            //---------------------------------------------
            
            $data[] = array(
                "id" => $row2['id'],
                "name" => $row2['name'],
                "family" => $row2['family'],
                "phone_number" => $phone_number_filtered,
                "price" => $price,
                "date_submit" => $date_submit,
                "final_pricepershare" => $row2['final_pricepershare'],
                "isTop" => $isTop,
                "diff_per" => $diff_per //Different Percentage
            );
            
        }
    }
    
    Print json_encode($data);
    
}

$conn->close();

?> 