<?php

include_once 'initialize.php';
include_once 'SecurityCheck.php';
include_once 'conn_db.php';
include_once 'jdf.php';

include_once 'Utils_Funcs.php';

mysqli_set_charset($conn, "utf8");

$querysearch = $conn->real_escape_string($_GET['querysearch']);

$limitval    = $conn->real_escape_string($_GET['limitval']);
$offsetval   = $conn->real_escape_string($_GET['offsetval']);

if (isset($limitval) && !empty($limitval)) {
    $uid = $mcrypt->decrypt($_GET['uid']);
    
    $searchQuery = get_compiled_searchQuery($querysearch, array('t_ss.sname'));
    
    $sql = "SELECT t_pp.id, t_pp.price, t_mc.final_pricepershare, t_pp.date_submit, t_mc.date_update, t_pp.rank, t_mc.count_participants, t_ss.sname as name FROM prices_predicted as t_pp
LEFT JOIN users ON users.id = t_pp.user_id
INNER JOIN matchs as t_mc ON t_mc.id = t_pp.company_id
INNER JOIN stock_shares as t_ss ON t_mc.symbol_id = t_ss.id
WHERE users.id = '$uid'" . $searchQuery . " ORDER BY t_pp.date_submit DESC" ." LIMIT " . $limitval . " OFFSET " . $offsetval;
    
    //با توجه به اینکه براساس تاریخ شرکت در مسابقه مرتب می شود اگر در آینده محدودیت تعداد شرکت در هر مسابقه هم افزایش یابد مشکلی در تریب نمایش به وجود نمی آید.
    
    $result = $conn->query($sql);
    
    $data = array();
    if ($result->num_rows > 0) {
        // output data of each row
        
        while ($row = $result->fetch_assoc()) {
            
            $id          = $row['id'];
            $namecompany = $row['name'];
            $price       = $row['price'];
            
            $date_miladi = $row['date_submit'];
            $date_shamsi = jdate("Y/m/d \r\n H:i", strtotime($date_miladi)); 
            $date_submit = $date_shamsi;
            
            $final_pricepershare = $row['final_pricepershare'];
            $final_info_match = "";
            $diff_per = "";
            
            if (is_numeric($final_pricepershare) && $final_pricepershare > 0) {
                
                $date_1 = jdate("(Y/m/d)", strtotime($row['date_update']));
                $final_info_match = number_format($final_pricepershare) . " ریال"; //Formatting price as comma separated
                $final_info_match .= " در " . $date_1;
                
                $diff_per = getDiff_TwoNumbers_toPercentage_withSign($final_pricepershare, $price);

            }  
            
            $data[] = array(
                "id" => $row['id'],
                "name" => $row['name'],
                "price" => $price,
                "date_submit" => $date_submit,
                "rank" => $row['rank'],
                "count_participants" => $row['count_participants'],
                "finfo_match" => $final_info_match,
                "diff_per" => $diff_per //Different Percentage
            );
        }
    }
    
    Print json_encode($data);
    
}



$conn->close();

?> 