<?php

include_once 'initialize.php';
include_once 'SecurityCheck.php';
include_once 'conn_db.php';
include_once 'Utils_Funcs.php';
include_once 'Utils_Match.php';
include_once 'jdf.php';

$line_sep = "\r\n";

$match_id = $conn->real_escape_string($_GET['id']);

date_default_timezone_set("Asia/Tehran");

//بررسی روزهای تعطیل ثابت بورس مثل جمعه
if (isNow_includes_Fixedholidays()) {
    print_response("Now_includes_Fixedholidays");
    exit;
}

if (ispossibleparticipateinmatch_time() !== 'true') {
    exit;
}

if (isCompany_duringmatch() !== 'true') {
    exit;
}

if (isSubmitedForecastForTheCompany_inOncePeriod() != 'true') {
    exit;
}

echo "competition_is_possible";

$conn->close();

function ispossibleparticipateinmatch_time()
{
    global $conn;
    
    $sql5    = "SELECT time_start_match, time_end_match FROM base_app_info ORDER BY id DESC LIMIT 1"; //WHERE id = 1
    $result5 = $conn->query($sql5);
    
    if ($result5 == FALSE) {
        echo 'Error_Connection';
        return 'exited_infunction';
    }
    
    if ($result5->num_rows > 0) {
        
        $row = $result5->fetch_assoc();
        
        global $start_time;
        global $end_time;
        
        $start_time = $row['time_start_match'];
        $end_time   = $row['time_end_match'];
        
        $start = strtotime($start_time);
        $end   = strtotime($end_time);
        
    } else {
        echo 'Error_Connection';
        return 'exited_infunction';
    }
    
    date_default_timezone_set("Asia/Tehran");
    
    if (time() >= $start && time() <= $end) {
        // possible
        return 'true';
    } else {
        // not possible
        print_response("notpossible_takepartinmatch_time");
        return 'false';
    }
    
}

function isCompany_duringmatch()
{
    global $match_id;
    global $conn;
    
    $query6  = "SELECT id FROM matchs t inner join ( select max(datesubmit) as MaxDate from matchs ) tm on t.final_pricepershare = '' AND Date(t.datesubmit) = Date(tm.MaxDate) WHERE id = '$match_id'";
    $result6 = $conn->query($query6);
    
    if ($result6 == FALSE) {
        echo 'Error_Connection';
        return 'exited_infunction';
    }
    
    if ($result6->num_rows > 0) {
        
        // possible
        return 'true';
        
    } else {
        
        // not possible
        print_response("isnot_company_duringmatch");
        return 'false';
    }
    
}

function isNow_includes_Fixedholidays()
{
    $dw = date("l"); //current day of week
    
    global $conn;
    $time_end_match = getSingleResult($conn, "SELECT time_end_match FROM base_app_info ORDER BY id DESC LIMIT 1", "");
    if ($time_end_match == false || empty($time_end_match)) {
        print_response("Error_Connection");
        return;
    }
    
    $Date_2         = new DateTime($time_end_match);
    
    $time_end_match = $Date_2->format("H:i:s");
    $now_time       = date("H:i:s");
    
    if ((strcasecmp($dw, "Thursday") == 0 && strtotime($now_time) > strtotime($time_end_match)) || strcasecmp($dw, "Friday") == 0) { //check compare => insensitively
        return true; //تعطیل
    }
    
    return false;
}

function isSubmitedForecastForTheCompany_inOncePeriod()
{
    global $match_id;
    global $user_id;
    global $conn;
    
    date_default_timezone_set("Asia/Tehran");
    //$date_currentDay = date("Y-m-d");
    
    $query7  = "SELECT id FROM prices_predicted WHERE company_id = '$match_id' AND user_id = '$user_id'"; 
    $result7 = $conn->query($query7);
    
    if ($result7 == FALSE) {
        echo 'Error_Connection';
        return 'exited_infunction';
    }
    
    if ($result7->num_rows > 0) {
        
        // not possible
        print_response("Already_SubmitedForecastForTheCompany_inThisDay");
        return 'false';
        
    } else {
        
        // possible
        return 'true';
        
    }
}

function print_response($action)
{
    global $line_sep;
    global $conn;
    global $start_time;
    global $end_time;
    
    switch (strtolower($action)) {
        
        case strtolower("notpossible_takepartinmatch_time"):
            
            $Date_1           = new DateTime($start_time);
            $Date_2         = new DateTime($end_time);

            $content = getMsg($Date_1, $Date_2, 1);
            $msg     = array(
                "action" => "open_action_cancelable", //notpossible_takepartinmatch_time
                "msg" => $content
            );
            Print json_encode($msg);
            break;
        
        case strtolower("isnot_company_duringmatch"):
            
            $Date_1           = new DateTime($start_time);
            $Date_2         = new DateTime($end_time);

            $content = getMsg($Date_1, $Date_2, 2);
            $msg = array(
                "action" => "isnot_company_duringmatch",
                "msg" => $content
            );
            Print json_encode($msg);
            break;
        
        case strtolower("Now_includes_Fixedholidays"):
            $content = "روز های تعطیل مسابقه ای برگزار نمی شود." . $line_sep . "لطفا بعدا تلاش کنید";
            
            $msg = array(
                "action" => "open_action_cancelable",
                "msg" => $content
            );
            Print json_encode($msg);
            break;
            
        case strtolower("Already_SubmitedForecastForTheCompany_inThisDay"):
            
            $content = "شما اخیرا برای این نماد قیمتی را ثبت کرده اید." . $line_sep . "در هر دوره، برای هر نماد فقط یکبار امکان ثبت قیمت وجود دارد";
            
            $msg = array(
                "action" => "open_action_cancelable",
                "msg" => $content
            );
            Print json_encode($msg);
            break;
        
        
        default:
            echo "Error_Connection";
            
    }
}

?> 