<?php

//تعطیلات ثابت مثل پنجشنبه جمعه البته این مورد مخصوص بورس است
function isDate_includes_Fixedholidays($int_time_ms)
{
    $dw = mstimeTostrtime($int_time_ms, "l"); //date("l", $int_time_ms);

    if (strcasecmp($dw, "Thursday") == 0 || strcasecmp($dw, "Friday") == 0) { //check compare => insensitively
        return true;
    }
    
    return false;
} 

//اگر در کرون جاب استفاده شود یا دستور شل یک عدد خیلی بزرگ که با حروف انگلیسی کوچک شده بر می گرداند
if (!function_exists('get_timeNow_ms')) {
function get_timeNow_ms()
{
      return round(microtime(true) * 1000);
}
}

function mstimeTostrtime($t_ms, $format)
{
    $t     = ($t_ms / 1000);
    $micro = sprintf("%06d", ($t - floor($t)) * 1000000);
    $d     = new DateTime(date('Y-m-d H:i:s.' . $micro, $t));
    
    return $d->format($format);
}

function getSingleResult($db, $query, $default_value)
{
    $result = $db->query($query);
    
    if ($result === FALSE) {
        return FALSE;
    }
    
    if ($result->num_rows > 0) {

        $row = $result->fetch_assoc();
        
        $numeric_indexed_array = array_values($row);
        return $numeric_indexed_array[0];
    }
    
    return $default_value;
    
}

//..................................................................

//Additional Condition
function get_compiled_searchQuery($str_sentence, $arrmap_include_fields)
{
    $isAbsolute = false;
    
    $result = "";
    
    if ( !empty(trim( str_replace(' ', '', $str_sentence))) && (is_array($arrmap_include_fields) && sizeof($arrmap_include_fields) > 0) ) {
        
       $components = preg_split('/\s+/', $str_sentence); //get words only with no spaces
       
       $arr_condition_total = array();
        
       foreach ($components as $comp) { //$comp => char or word
 
            foreach ($arrmap_include_fields as $field) {
                $comp = trim($comp);
                if (!empty($comp)) {
                    if ($isAbsolute === true) {
                        $arr_condition_total[$field] = array($field ." =" ."'" .$comp. "'"); 
                    } else{
                        $arr_condition_total[$field] = array($field ." LIKE N" ."'%" .$comp. "%'");   
                    }
                }
            }   
               
       }

        $arr_condition_final = array();
        foreach ($arr_condition_total as $arr_conditions) {
            
            if (is_array($arr_conditions) && sizeof($arr_conditions) > 0) {
                $arr_condition_final[] = "(" .implode(' AND ', $arr_conditions). ")";
            }
            
        }  
       
       
       $result = " AND (" .implode(' OR ', $arr_condition_final). ")";
 
    }
  
    return $result;
  
}

function get_count($db, $cat_id)
{
    return get_value_cat($db, "count", $cat_id, "");
}

function get_count2($db, $cat_id, $last_id)
{
    $condition = "";
    
    if (is_numeric($last_id) && $last_id > 0) { //Just For Optimization
        $condition = " AND cat_posts.ID > " . $last_id;
        
    } else {
        $condition = "";
    }
    
    return get_value_cat($db, "count", $cat_id, $condition);
}

function get_MaxPostId($db, $cat_id)
{
    return get_value_cat($db, "max", $cat_id, "");
}

function get_value_cat($db, $action, $cat_id, $condition)
{
    $field_slection = "";
    if ($action == "count") {
        $field_slection = "COUNT( DISTINCT cat_posts.ID )";
    } else{
        $field_slection = "Max( cat_posts.ID )";
    }
    
    $query = "SELECT ".$field_slection." AS result_1 
FROM wp_term_taxonomy AS cat_term_taxonomy 
INNER JOIN wp_terms AS cat_terms ON cat_term_taxonomy.term_id = cat_terms.term_id 
INNER JOIN wp_term_relationships AS cat_term_relationships ON cat_term_taxonomy.term_taxonomy_id = cat_term_relationships.term_taxonomy_id 
INNER JOIN wp_posts AS cat_posts ON cat_term_relationships.object_id = cat_posts.ID 
WHERE cat_posts.post_type = 'post' AND (cat_posts.post_status = 'publish' OR cat_posts.post_status = 'private') AND cat_term_taxonomy.taxonomy = 'category' AND cat_terms.term_id = :cat_id" .$condition;
    
    $result = $db->prepare($query);
    $result->execute([ 'cat_id' => $cat_id ]);
    
    if ($result === FALSE) {
        return 'Error_Connection';
    }
    
    foreach ($result as $print) {
        return $print['result_1'];
    }
    
}

function getDiff_TwoNumbers_toPercentage_withSign ($Based_1, $Comparable_1) // As String
{ 
	$diff_per = getDiff_TwoNumbers_toPercentage($Based_1, $Comparable_1);
	if (startsWith($diff_per, '-')) {
		$diff_per = "%". getNumb_Two_DecimalLimit(str_replace("-", '', $diff_per)) ."-"; 
	} else {    
		if (getNumb_Two_DecimalLimit($diff_per) == getNumb_Two_DecimalLimit("0")) { //جز صحیح و اعشار عدد صفر هستند
			$diff_per = "%". getNumb_Two_DecimalLimit($diff_per); 
		} else {
			$diff_per = "%". getNumb_Two_DecimalLimit($diff_per) ."+"; 
		}
	}

    return $diff_per;
}    

function getNumb_Two_DecimalLimit( $val )
{
    return getNumb_DecimalLimit($val, 2);
}

function getDiff_TwoNumbers_toPercentage ($a, $b) 
{ 
    $result = 0; 
    $result = (($b - $a) * 100) / $a; 
  
    return $result; 
} 

function getNumb_DecimalLimit( $val, $countDecimal_Limit )
{
    if (is_decimal($val)) {
        return number_format($val, $countDecimal_Limit);
    }
    
    return $val;
}

function startsWith( $haystack, $needle ) {
     $length = strlen( $needle );
     return substr( $haystack, 0, $length ) === $needle;
}

function endsWith( $haystack, $needle ) {
    $length = strlen( $needle );
    if( !$length ) {
        return true;
    }
    return substr( $haystack, -$length ) === $needle;
}

function is_decimal( $val )
{
    return is_numeric( $val ) && floor( $val ) != $val;
}

//--------------------------------------------------------------
function toPersianNum($number)
{
    $number = str_replace("1","۱",$number);
    $number = str_replace("2","۲",$number);
    $number = str_replace("3","۳",$number);
    $number = str_replace("4","۴",$number);
    $number = str_replace("5","۵",$number);
    $number = str_replace("6","۶",$number);
    $number = str_replace("7","۷",$number);
    $number = str_replace("8","۸",$number);
    $number = str_replace("9","۹",$number);
    $number = str_replace("0","۰",$number);
    return $number;
}

function toEnglishNum($number)
{
    $number = str_replace("۱","1",$number);
    $number = str_replace("۲","2",$number);
    $number = str_replace("۳","3",$number);
    $number = str_replace("۴","4",$number);
    $number = str_replace("۵","5",$number);
    $number = str_replace("۶","6",$number);
    $number = str_replace("۷","7",$number);
    $number = str_replace("۸","8",$number);
    $number = str_replace("۹","9",$number);
    $number = str_replace("۰","0",$number);
    return $number;
}

?> 